// ActUtlWrap.cpp : Implementation of CActUtlWrap

#include "stdafx.h"
#include "ActUtlWrap.h"


// CActUtlWrap
CActUtlWrap::CActUtlWrap()
{
	m_lLogicalStationNumber = 0;
	m_bstrPassword = NULL;
	mp_IActUtlType = NULL;
}

CActUtlWrap::~CActUtlWrap()
{
	if(NULL != m_bstrPassword){
		::SysFreeString(m_bstrPassword);
		m_bstrPassword = NULL;
	}
	if(NULL != mp_IActUtlType){
		mp_IActUtlType->Release();
		mp_IActUtlType = NULL;
	}
}

STDMETHODIMP CActUtlWrap::get_ActLogicalStationNumber(LONG* pVal)
{
	*pVal = m_lLogicalStationNumber;
	return S_OK;
}


STDMETHODIMP CActUtlWrap::put_ActLogicalStationNumber(LONG newVal)
{
	m_lLogicalStationNumber = newVal;
	return S_OK;
}


STDMETHODIMP CActUtlWrap::get_ActPassword(BSTR* pVal)
{
	if(NULL == pVal){
		return S_FALSE;
	}
	::SysFreeString(*pVal);
	*pVal = ::SysAllocString(m_bstrPassword);
	return S_OK;
}


STDMETHODIMP CActUtlWrap::put_ActPassword(BSTR newVal)
{
	if(NULL != m_bstrPassword){
		::SysFreeString(m_bstrPassword);
	}
	if(NULL == newVal){
		m_bstrPassword = ::SysAllocString(_T(""));
	}else{
		m_bstrPassword = ::SysAllocString(newVal);
	}
	return S_OK;
}


STDMETHODIMP CActUtlWrap::Open(LONG* lplReturnCode)
{
	HRESULT hr = S_OK;

	//CoInitialize(NULL);

	if(NULL == mp_IActUtlType){

		//Create Instance of ActiveX Control
		//(for ActUtlType)
		hr =  ::CoCreateInstance(	(REFCLSID)CLSID_ActUtlType,
											(LPUNKNOWN)NULL,
											(DWORD)CLSCTX_SERVER,
											(REFIID)IID_IActUtlType,
											(LPVOID*)&mp_IActUtlType
											);

		if(!SUCCEEDED(hr)){
			return hr;
		}	
	}

	//Set the value of 'LogicalStationNumber' to the control property
	hr = mp_IActUtlType->put_ActLogicalStationNumber(m_lLogicalStationNumber);
	if(!SUCCEEDED(hr)){
		return hr;
	}
	hr = mp_IActUtlType->put_ActPassword(m_bstrPassword);
	if(!SUCCEEDED(hr)){
		return hr;
	}

	//Open Method is Execututed.
	LONG lActCtrlRet    = 0	;
	hr = mp_IActUtlType->Open(&lActCtrlRet);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		*lplReturnCode = lActCtrlRet;
		return S_OK;

	}
}


STDMETHODIMP CActUtlWrap::Close(LONG* lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//Close Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->Close(lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
	
	//Clear Object
	if(NULL != m_bstrPassword){
		::SysFreeString(m_bstrPassword);
		m_bstrPassword = NULL;
	}
	if(NULL != mp_IActUtlType){
		mp_IActUtlType->Release();
		mp_IActUtlType = NULL;
	}

}


STDMETHODIMP CActUtlWrap::ReadDeviceBlock2(BSTR szDevice, LONG lSize, SHORT* lpsData, LONG* lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//ReadDeviceBlock2 Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->ReadDeviceBlock2(szDevice, lSize, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}


STDMETHODIMP CActUtlWrap::WriteDeviceBlock2(BSTR szDevice, LONG lSize, SHORT* lpsData, LONG* lplReturnCode)
{
	//WriteDeviceBlock2 Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->WriteDeviceBlock2(szDevice, lSize, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}


STDMETHODIMP CActUtlWrap::ReadDeviceRandom2(BSTR szDeviceList, LONG lSize, SHORT* lpsData, LONG* lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//ReadDeviceRandom2 Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->ReadDeviceRandom2(szDeviceList, lSize, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}


STDMETHODIMP CActUtlWrap::WriteDeviceRandom2(BSTR szDeviceList, LONG lSize, SHORT* lpsData, LONG* lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//WriteDeviceRandom2 Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->WriteDeviceRandom2(szDeviceList, lSize, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::CheckControl(LONG* lplReturnCode)
{
	if(NULL == mp_IActUtlType){
		//When ActUtlType is not Enabled, return ErrorCode.
		*lplReturnCode = 0x80201201;
		return S_FALSE;
	}
	*lplReturnCode = 0;
	return S_OK;
}

STDMETHODIMP CActUtlWrap::GetCpuType(BSTR *lpszCpuName, LONG *lplCpuCode, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//GetCpuType Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->GetCpuType(lpszCpuName, lplCpuCode, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::SetCpuStatus(LONG lOperation, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//SetCpuStatus Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->SetCpuStatus(lOperation, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::ReadDeviceBlock(BSTR szDevice, LONG lSize, LONG *lplData,	LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//ReadDeviceBlock Method is Executed.
	HRESULT	hr;
	hr = mp_IActUtlType->ReadDeviceBlock(szDevice, lSize, lplData,	lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::WriteDeviceBlock(BSTR szDevice, LONG lSize, LONG *lplData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//Processing WriteDeviceBlock Method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->WriteDeviceBlock(szDevice, lSize, lplData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::ReadDeviceRandom(BSTR szDeviceList, LONG lSize, LONG *lplData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//ReadDeviceRandom Method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->ReadDeviceRandom(szDeviceList, lSize, lplData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::WriteDeviceRandom(BSTR szDeviceList, LONG lSize, LONG *lplData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//WriteDeviceRandom Method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->WriteDeviceRandom(szDeviceList, lSize, lplData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::ReadBuffer(LONG lStartIO,	LONG lAddress, LONG lSize, SHORT *lpsData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//ReadBuffer Method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->ReadBuffer(lStartIO, lAddress, lSize, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::WriteBuffer(LONG lStartIO, LONG lAddress, LONG lSize,	SHORT *lpsData,	LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//WriteBuffer method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->WriteBuffer(lStartIO, lAddress, lSize, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::GetClockData(SHORT *lpsYear, SHORT *lpsMonth, SHORT *lpsDay, SHORT *lpsDayOfWeek, SHORT *lpsHour,	SHORT *lpsMinute, SHORT *lpsSecond,	LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//GetClockData method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->GetClockData(lpsYear, lpsMonth, lpsDay, lpsDayOfWeek, lpsHour,	lpsMinute, lpsSecond, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}
STDMETHODIMP CActUtlWrap::SetClockData(SHORT sYear,	SHORT sMonth, SHORT sDay, SHORT sDayOfWeek, SHORT sHour, SHORT sMinute, SHORT sSecond, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//SetClockData method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->SetClockData(sYear, sMonth, sDay, sDayOfWeek, sHour, sMinute, sSecond, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::SetDevice(BSTR szDevice, LONG lData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//SetDevice method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->SetDevice(szDevice, lData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::GetDevice(BSTR szDevice, LONG *lplData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//Getdevice Method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->GetDevice(szDevice, lplData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}

STDMETHODIMP CActUtlWrap::SetDevice2(BSTR szDevice, SHORT sData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//SetDevice2 method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->SetDevice2(szDevice, sData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}
STDMETHODIMP CActUtlWrap::GetDevice2(BSTR szDevice, SHORT *lpsData, LONG *lplReturnCode)
{
	if(S_FALSE == CheckControl(lplReturnCode)){
		return S_FALSE;
	}
	//GetDevice2 method is executed.
	HRESULT	hr;
	hr = mp_IActUtlType->GetDevice2(szDevice, lpsData, lplReturnCode);
	if(!SUCCEEDED(hr)){
		return hr;
	}else{
		return S_OK;
	}
}
