// ActUtlWrap.h : Declaration of the CActUtlWrap

#pragma once
#include "resource.h"       // main symbols



#include "ActUtlWrapper_i.h"

// Custom Include File for Control Interface.
#include "..\..\include\ActUtlType_i.h"
#include "..\..\include\ActUtlType_i.c"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif

using namespace ATL;


// CActUtlWrap

class ATL_NO_VTABLE CActUtlWrap :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CActUtlWrap, &CLSID_ActUtlWrap>,
	public IActUtlWrap
{
public:
	CActUtlWrap();
	~CActUtlWrap();
	//CActUtlWrap()
	//{
	//}

DECLARE_REGISTRY_RESOURCEID(IDR_ACTUTLWRAP)


BEGIN_COM_MAP(CActUtlWrap)
	COM_INTERFACE_ENTRY(IActUtlWrap)
END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}

public:

	STDMETHOD(get_ActLogicalStationNumber)(LONG* pVal);
	STDMETHOD(put_ActLogicalStationNumber)(LONG newVal);
	STDMETHOD(get_ActPassword)(BSTR* pVal);
	STDMETHOD(put_ActPassword)(BSTR newVal);
	STDMETHOD(Open)(LONG* lplReturnCode);
	STDMETHOD(Close)(LONG* lplReturnCode);
	STDMETHOD(ReadDeviceBlock2)(BSTR szDevice, LONG lSize, SHORT* lpsData, LONG* lplReturnCode);
	STDMETHOD(WriteDeviceBlock2)(BSTR szDevice, LONG lSize, SHORT* lpsData, LONG* lplReturnCode);
	STDMETHOD(ReadDeviceRandom2)(BSTR szDeviceList, LONG lSize, SHORT* lpsData, LONG* lplReturnCode);
	STDMETHOD(WriteDeviceRandom2)(BSTR szDeviceList, LONG lSize, SHORT* lpsData, LONG* lplReturnCode);
	STDMETHOD(CheckControl)(LONG* lplReturnCode);
	STDMETHOD(GetCpuType)(BSTR *lpszCpuName, LONG *lplCpuCode, LONG* lplReturnCode);
	STDMETHOD(SetCpuStatus)(LONG lOperation, LONG *lplReturnCode);
	STDMETHOD(ReadDeviceBlock)(BSTR szDevice, LONG lSize, LONG *lplData, LONG *lplReturnCode);
	STDMETHOD(WriteDeviceBlock)(BSTR szDevice, LONG lSize, LONG *lplData, LONG *lplReturnCode);
	STDMETHOD(ReadDeviceRandom)(BSTR szDeviceList, LONG lSize, LONG *lplData, LONG *lplReturnCode);
	STDMETHOD(WriteDeviceRandom)(BSTR szDeviceList, LONG lSize, LONG *lplData, LONG *lplReturnCode);
	STDMETHOD(ReadBuffer)(LONG lStartIO, LONG lAddress, LONG lSize, SHORT *lpsData, LONG *lplReturnCode);
	STDMETHOD(WriteBuffer)(LONG lStartIO, LONG lAddress, LONG lSize, SHORT *lpsData, LONG *lplReturnCode);
	STDMETHOD(GetClockData)(SHORT *lpsYear, SHORT *lpsMonth, SHORT *lpsDay, SHORT *lpsDayOfWeek, SHORT *lpsHour, SHORT *lpsMinute, SHORT *lpsSecond, LONG *lplReturnCode   );
	STDMETHOD(SetClockData)(SHORT sYear, SHORT sMonth, SHORT sDay, SHORT sDayOfWeek, SHORT sHour, SHORT sMinute, SHORT sSecond, LONG *lplReturnCode);
	STDMETHOD(SetDevice)(BSTR szDevice, LONG lData, LONG* lplReturnCode);
	STDMETHOD(GetDevice)(BSTR szDevice, LONG *lplData, LONG *lplReturnCode);
	STDMETHOD(SetDevice2)(BSTR szDevice, SHORT sData, LONG *lplReturnCode);
	STDMETHOD(GetDevice2)(BSTR szDevice, SHORT *lpsData, LONG *lplReturnCode);

protected:

	//local variable
	LONG			m_lLogicalStationNumber;
	BSTR			m_bstrPassword;
	IActUtlType*	mp_IActUtlType;

};

OBJECT_ENTRY_AUTO(__uuidof(ActUtlWrap), CActUtlWrap)
