Public Class Form1

    Public Declare Function timeBeginPeriod Lib "winmm.dll" (ByVal uPeriod As Integer) As Integer
    Public Declare Function timeEndPeriod Lib "winmm.dll" (ByVal uPeriod As Integer) As Integer

#Region "Additional initialization (including Form_Load processing)"

    'The declaration of instance value for ACT controls
    'When you use Dot controls by 'References', you should program as follows;
    Private com_ReferencesUtlType As ActUtlTypeLib.ActUtlType

    Private Sub frm_Sample_References_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Create instance for ACT Controls
        com_ReferencesUtlType = New ActUtlTypeLib.ActUtlType

        If IntPtr.Size = 4 Then
            txt_Process.Text = "32bit"
        ElseIf IntPtr.Size = 8 Then
            txt_Process.Text = "64bit"
        End If

    End Sub

#End Region


#Region "Processing of Open button"

    Private Sub btn_Open_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Open.Click

        Dim iReturnCode As Integer              'Return Code
        Dim iLogicalStationNumber As Integer    'LogicalStationNumber

        'Displayed output data is cleared.
        ClearDisplay()

        '
        'Processing of Open method
        '
        Try
            'Check the 'LogicalStationNumber'.(If succeeded, the value is gotten.)
            If GetIntValue(txt_LogicalStationNumber, iLogicalStationNumber) = False Then
                'If failed, this process is end.			
                Exit Sub
            End If

            'Set the value of 'LogicalStationNumber' to the property.
            com_ReferencesUtlType.ActLogicalStationNumber = iLogicalStationNumber

            'The Open method is executed.
            iReturnCode = com_ReferencesUtlType.Open()

            If iReturnCode = 0 Then
                'When the Open method is succeeded, disable the TextBox of 'LogocalStationNumber'.
                txt_LogicalStationNumber.Enabled = False
            End If


            'Exception processing
        Catch exception As Exception
            MessageBox.Show(exception.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region


#Region "Processing of Close button"

    Private Sub btn_Close_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Close.Click

        Dim iReturnCode As Integer     'Return Code

        'Displayed output data is cleared.
        ClearDisplay()

        '
        'Processing of Close method
        '
        Try
            'The Close method is executed.
            iReturnCode = com_ReferencesUtlType.Close()

            'When The Close method is succeeded, enable the TextBox of 'LogicalStationNumber'.
            If iReturnCode = 0 Then
                txt_LogicalStationNumber.Enabled = True
            End If

        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region


#Region "Processing of ReadDeviceRandom2 button"

    Private Sub btn_ReadDeviceRandom2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadDeviceRandom2.Click

        Dim iReturnCode As Integer              'return code
        Dim szDeviceName As String = ""         'List data for 'DeviceName'
        Dim iNumberOfDeviceName As Integer = 0  'Data for 'DeviceValue'
        Dim sharrDeviceValue() As Short         'Data for 'DeviceValue'
        Dim szarrData() As String               'Array for 'Data'
        Dim iNumber As Integer                  'loop counter
        Dim iNumberOfRetry As Integer           'retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameRandom.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeRandom, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Create DeviceName array
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)

        'Check the 'RetryCount'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceRandom2 method
        '
        Try
            'system timers remains in high resolution mode.
            timeBeginPeriod(1)
            'record the time of process start.
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'ReadDeviceRandom2 method is executed.
                iReturnCode = com_ReferencesUtlType.ReadDeviceRandom2(szDeviceName, _
                                                                     iNumberOfDeviceName, _
                                                                     sharrDeviceValue(0))
            Next
            'record the time of process end.
            DateTimeEnd = Now
            'system timers remains in normal mode.
            timeEndPeriod(1)
            'Calclate TimeSpan and display it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(iNumberOfDeviceName - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To iNumberOfDeviceName - 1
                szarrData(iNumber) = sharrDeviceValue(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region


#Region "Processing of WriteDeviceRandom2 button"

    Private Sub btn_WriteDeviceRandom2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteDeviceRandom2.Click

        Dim iReturnCode As Integer              'return code
        Dim szDeviceName As String = ""         'List data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List count for 'Device Name List'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim iNumber As Integer                  'loop counter
        Dim iNumberOfRetry As Integer           'retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameRandom.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeRandom, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Check the 'DeviceValue'.(If succeeded, the value is gotten.)
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)
        If GetShortArray(txt_DeviceDataRandom, sharrDeviceValue) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteDeviceRandom2 method
        '
        Try
            'system timers remains in high resolution mode
            timeBeginPeriod(1)
            'record time of process starting.
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The WriteDeviceRandom2 method is executed.
                iReturnCode = com_ReferencesUtlType.WriteDeviceRandom2(szDeviceName, _
                                                                      iNumberOfDeviceName, _
                                                                      sharrDeviceValue(0))
            Next
            'record time of process ending.
            DateTimeEnd = Now
            'system timers remains in normal mode.
            timeEndPeriod(1)
            'Calclate TimeSpan and display it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'exception processing.
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region


#Region "Processing of ReadDeviceBlock2 button"

    Private Sub btn_ReadDeviceBlock2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadDeviceBlock2.Click

        Dim iReturnCode As Integer              'return code
        Dim szDeviceName As String = ""         'List data for 'DeviceName'
        Dim iNumberOfDeviceName As Integer = 0  'List count for 'DeviceName'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim szarrData() As String               'Data for 'Device Value'
        Dim iNumber As Integer                  'loop counter
        Dim iNumberOfRetry As Integer           'retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameBlock.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeBlock, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Allocate space for the device value
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceBlock2 method
        '
        Try
            'system timers remains in high resolution mode.
            timeBeginPeriod(1)
            'record time of process stating.
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'the ReadDeviceBlock2 method is excuted.
                iReturnCode = com_ReferencesUtlType.ReadDeviceBlock2(szDeviceName, _
                                                                    iNumberOfDeviceName, _
                                                                    sharrDeviceValue(0))
            Next
            'record time of process ending.
            DateTimeEnd = Now
            'system timers remains in normal mode.
            timeEndPeriod(1)
            'Calclate TimeSpan and display it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(iNumberOfDeviceName - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To iNumberOfDeviceName - 1
                szarrData(iNumber) = sharrDeviceValue(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region


#Region "Processing of WriteDeviceBlock2 button"

    Private Sub btn_WriteDeviceBlock2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteDeviceBlock2.Click

        Dim iReturnCode As Integer              'return code
        Dim szDeviceName As String = ""         'List data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'Count of 'Device Name List'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim iNumber As Integer                  'loop counter
        Dim iNumberOfRetry As Integer           'retry coutner
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'deviceName'.
        '  Join each line(StringType array) of 'deviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameBlock.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeBlock, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Allocate space for the device Name
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)
        If GetShortArray(txt_DeviceDataBlock, sharrDeviceValue) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Check the 'RetryCount'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteDeviceBlock2 method
        '
        Try
            'System timers remains in high resolution mode.
            timeBeginPeriod(1)
            'record time of process starting.
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The WriteDeviceRandom2 method is executed.
                iReturnCode = com_ReferencesUtlType.WriteDeviceBlock2(szDeviceName, _
                                                                     iNumberOfDeviceName, _
                                                                     sharrDeviceValue(0))
            Next
            'record time of process ending.
            DateTimeEnd = Now
            'System timers remains in normal mode.
            timeEndPeriod(1)
            'Calclate timespan and display it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region


#Region "Processing of getting ShortType array from StringType array of multiline TextBox"

    Private Function GetShortArray(ByVal txt_SourceOfShortArray As TextBox, ByRef sharrShortArrayValue() As Short) As Boolean

        Dim iSizeOfShortArray As Integer        'Size of ShortType array
        Dim iNumber As Integer                  'loop counter

        'Get the size of IntType array.
        iSizeOfShortArray = txt_SourceOfShortArray.Lines.Length

        'Get each element of IntType array.
        For iNumber = 0 To iSizeOfShortArray - 1
            Try
                sharrShortArrayValue(iNumber) = Convert.ToInt16(txt_SourceOfShortArray.Lines(iNumber))

            Catch exExcepion As Exception
                'When the value is nothing or out of the range, the exception is processed.
                MessageBox.Show(exExcepion.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return False
            End Try
        Next iNumber

        'Normal End
        Return True

    End Function

#End Region


#Region "Processing of getting IntType array from StringType array of multiline TextBox"

    Private Function GetIntArray(ByVal txt_SourceOfIntegerArray As TextBox, ByRef iarrIntegerArrayValue() As Integer) As Boolean

        Dim iSizeOfIntArray As Integer          'Size of IntType array
        Dim iNumber As Integer                  'loop Counter

        'Get the size of IntType array.
        iSizeOfIntArray = txt_SourceOfIntegerArray.Lines.Length

        'Get each element of IntType array.
        For iNumber = 0 To iSizeOfIntArray - 1
            Try
                iarrIntegerArrayValue(iNumber) = Convert.ToInt32(txt_SourceOfIntegerArray.Lines(iNumber))

            Catch exExcepion As Exception
                'When the value is nothing or out of the range, the exception is processed.
                MessageBox.Show(exExcepion.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return False
            End Try
        Next iNumber

        'normal end.
        Return True

    End Function

#End Region


#Region "Processing of getting 32bit integer from TextBox"

    Private Function GetIntValue(ByVal txt_SourceOfIntValue As TextBox, ByRef iGottenIntValue As Integer) As Boolean

        'Get the value as 32bit integer from a TextBox
        Try
            iGottenIntValue = Convert.ToInt32(txt_SourceOfIntValue.Text)

        Catch exExcepion As Exception
            'When the value is nothing or out of the range, the exception is processed.
            MessageBox.Show(exExcepion.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End Try

        'normal end.
        Return True

    End Function

#End Region


#Region "Processing of clear displayed output data"

    Private Sub ClearDisplay()

        'Clear TextBox of 'ReturnCode','Data'
        txt_ReturnCode.Text = ""
        txt_Data.Text = ""
        txt_AverageTime.Text = ""
        Me.Refresh()

    End Sub

#End Region

#Region "Processing of Close button"

    Private Sub frm_Sample_References_Closed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        'Clear instance for Controls
        com_ReferencesUtlType = Nothing

    End Sub

#End Region


End Class