Public Class Form1

#Region "Additional initialization (including Form_Load processing)"

    '
    Public Declare Function timeBeginPeriod Lib "winmm.dll" (ByVal uPeriod As Integer) As Integer
    Public Declare Function timeEndPeriod Lib "winmm.dll" (ByVal uPeriod As Integer) As Integer

    'The declaration of instance value for ACT controls
    Private com_ReferencesUtlType As ActUtlWrapperLib.ActUtlWrap
    Private com_ReferencesMsg As ActMsgWrapperLib.ActMsgWrap

    Private Sub frm_Sample_References_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Create instance for ACT Controls
        com_ReferencesUtlType = New ActUtlWrapperLib.ActUtlWrap
        com_ReferencesMsg = New ActMsgWrapperLib.ActMsgWrap

        If IntPtr.Size = 4 Then
            txt_Process.Text = "32bit"
        ElseIf IntPtr.Size = 8 Then
            txt_Process.Text = "64bit"
        End If
    End Sub

    Protected Overrides Sub Finalize()
        com_ReferencesUtlType = Nothing
        com_ReferencesMsg = Nothing
        MyBase.Finalize()
    End Sub

#End Region

#Region " Processing of Open button "

    Private Sub btn_Open_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Open.Click

        Dim iReturnCode As Integer              'return code
        Dim iLogicalStationNumber As Integer    'logicalstationnumber

        'Displayed output data is cleared.
        ClearDisplay()

        '
        'Processing of Open method
        '
        Try
            'Check the 'LogicalStationNumber'.(If succeeded, the value is gotten.)
            If GetIntValue(txt_LogicalStationNumber, iLogicalStationNumber) = False Then
                Exit Sub
            End If
            com_ReferencesUtlType.ActLogicalStationNumber = iLogicalStationNumber

            'The Open method is executed.
            iReturnCode = com_ReferencesUtlType.Open()

            If iReturnCode = 0 Then
                txt_LogicalStationNumber.Enabled = False
            End If

            'Exception processing
        Catch exception As Exception
            MessageBox.Show(exception.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing of Close button "

    Private Sub btn_Close_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Close.Click

        Dim iReturnCode As Integer     'return code

        'Displayed output data is cleared.
        ClearDisplay()

        '
        'Processing of Close method
        '
        Try
            'The Close method is executed.
            iReturnCode = com_ReferencesUtlType.Close()

            'When The Close method is succeeded, enable the TextBox of 'LogocalStationNumber'.
            If iReturnCode = 0 Then
                txt_LogicalStationNumber.Enabled = True
            End If

        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing of ReadDeviceRandom2 button"

    Private Sub btn_ReadDeviceRandom2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadDeviceRandom2.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'List Data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List Data Count fo 'Device Name'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim szarrData() As String               'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameRandom.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeRandom, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Resize the array for 'DeviceValue'.
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceRandom2 method
        '
        Try
            'System Timers Remains in High resolution Mode
            timeBeginPeriod(1)
            'Record the Start Time of Procrss
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The ReadDeviceRandom2 method is executed.
                iReturnCode = com_ReferencesUtlType.ReadDeviceRandom2(szDeviceName, _
                                                                     iNumberOfDeviceName, _
                                                                     sharrDeviceValue(0))
            Next
            'Record the End Time of Procrss
            DateTimeEnd = Now
            'System Timers Remains in Normal mode.
            timeEndPeriod(1)
            'Display the Time Span of Process.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception Processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(iNumberOfDeviceName - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To iNumberOfDeviceName - 1
                szarrData(iNumber) = sharrDeviceValue(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region

#Region " Processing of WriteDeviceRandom2 button "

    Private Sub btn_WriteDeviceRandom2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteDeviceRandom2.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'List Data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List Data Count for 'device Name'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop counter
        Dim iNumberOfRetry As Integer           'Retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameRandom.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeRandom, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Check the 'DeviceValue'.(If succeeded, the value is gotten.)
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)
        If GetShortArray(txt_DeviceDataRandom, sharrDeviceValue) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteDeviceRandom2 method
        '
        Try
            'System timers remain in High Resolution Mode
            timeBeginPeriod(1)
            'record the Start Time 
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry
                'The WriteDeviceRandom2 method is executed.
                iReturnCode = com_ReferencesUtlType.WriteDeviceRandom2(szDeviceName, _
                                                                      iNumberOfDeviceName, _
                                                                      sharrDeviceValue(0))

            Next
            'Record the End time
            DateTimeEnd = Now
            'System timers remain in Normal Mode
            timeEndPeriod(1)
            'Calclate the Time Span and Displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing of ReadDeviceBlock2 button "

    Private Sub btn_ReadDeviceBlock2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadDeviceBlock2.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'List Data for 'DeviceName'
        Dim iNumberOfDeviceName As Integer = 0  'List count for 'DeviceNameList'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim szarrData() As String               'Data for 'Device Valeu'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameBlock.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeBlock, iNumberOfDeviceName) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Allocate space for the device value
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceBlock2 method
        '
        Try
            'System timers remain in High resolutuon mode
            timeBeginPeriod(1)
            'Record the Start time of Process
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'ReadDeviceBlock2 method is Executed.
                iReturnCode = com_ReferencesUtlType.ReadDeviceBlock2(szDeviceName, _
                                                                    iNumberOfDeviceName, _
                                                                    sharrDeviceValue(0))

            Next
            'record the end time of process
            DateTimeEnd = Now
            'System timers remain in normal mode.
            timeEndPeriod(1)
            'Calucurate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception Processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(iNumberOfDeviceName - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To iNumberOfDeviceName - 1
                szarrData(iNumber) = sharrDeviceValue(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region

#Region " Processing of WriteDeviceBlock2 button"

    Private Sub btn_WriteDeviceBlock2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteDeviceBlock2.Click

        Dim iReturnCode As Integer              'return Code
        Dim szDeviceName As String = ""         'Data List for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List Count for 'Device Name List'
        Dim sharrDeviceValue() As Short         'Data for 'Device Data'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameBlock.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeBlock, iNumberOfDeviceName) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'DeviceValue'.(If succeeded, the value is gotten.)
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)
        If GetShortArray(txt_DeviceDataBlock, sharrDeviceValue) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteDeviceBlock2 method
        '
        Try
            'Sstem timers remain in high Resolution mode.
            timeBeginPeriod(1)
            'Record the start time of process
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The WriteDeviceRandom2 method is executed.
                iReturnCode = com_ReferencesUtlType.WriteDeviceBlock2(szDeviceName, _
                                                                     iNumberOfDeviceName, _
                                                                     sharrDeviceValue(0))

            Next
            'Record the end time of process
            DateTimeEnd = Now
            'System timers remain in Normal mode.
            timeEndPeriod(1)
            'Calclate the time span of process and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception Processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing of getting ShortType array from StringType array of multiline TextBox "

    Private Function GetShortArray(ByVal txt_SourceOfShortArray As TextBox, ByRef sharrShortArrayValue() As Short) As Boolean

        Dim iSizeOfShortArray As Integer        'Size of ShortType array
        Dim iNumber As Integer                  'Loop Conuter

        'Get the size of ShortType array.
        iSizeOfShortArray = txt_SourceOfShortArray.Lines.Length

        'Get each element of ShortType array.
        For iNumber = 0 To iSizeOfShortArray - 1
            Try
                sharrShortArrayValue(iNumber) = Convert.ToInt16(txt_SourceOfShortArray.Lines(iNumber))

            Catch exExcepion As Exception
                'When the value is nothing or out of the range, the exception is processed.
                MessageBox.Show(exExcepion.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return False
            End Try
        Next iNumber

        'Normal end.
        Return True

    End Function

#End Region

#Region " Processing of getting IntType array from StringType array of multiline TextBox "

    Private Function GetIntArray(ByVal txt_SourceOfIntegerArray As TextBox, ByRef iarrIntegerArrayValue() As Integer) As Boolean

        Dim iSizeOfIntArray As Integer          'Size of inttype Array
        Dim iNumber As Integer                  'Loop Counter

        'Get the size of IntType array.
        iSizeOfIntArray = txt_SourceOfIntegerArray.Lines.Length

        'Get each element of IntType array.
        For iNumber = 0 To iSizeOfIntArray - 1
            Try
                iarrIntegerArrayValue(iNumber) = Convert.ToInt32(txt_SourceOfIntegerArray.Lines(iNumber))

            Catch exExcepion As Exception
                'When the value is nothing or out of the range, the exception is processed.
                MessageBox.Show(exExcepion.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return False
            End Try
        Next iNumber

        'Normal end.
        Return True

    End Function

#End Region

#Region " Processing of getting 32bit integer from TextBox "

    Private Function GetIntValue(ByVal txt_SourceOfIntValue As TextBox, ByRef iGottenIntValue As Integer) As Boolean

        'Get the value as 32bit integer from a TextBox
        Try

            Dim FromString As String = txt_SourceOfIntValue.Text
            If 0 <= FromString.IndexOf("0x") Or 0 <= FromString.IndexOf("0X") Then
                iGottenIntValue = Convert.ToInt32(txt_SourceOfIntValue.Text.Substring(2), 16)
            Else
                iGottenIntValue = Convert.ToInt32(txt_SourceOfIntValue.Text)
            End If


        Catch exExcepion As Exception
            'When the value is nothing or out of the range, the exception is processed.
            MessageBox.Show(exExcepion.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End Try

        'Normal End.
        Return True

    End Function

#End Region

#Region "Processing of clear displayed output data"

    Private Sub ClearDisplay()

        'Clear TextBox of 'ReturnCode','Data', 'AverageTime'
        txt_ReturnCode.Text = ""
        txt_Data.Text = ""
        txt_AverageTime.Text = ""
        Me.Refresh()

    End Sub

#End Region

#Region "Processing of FormClosed"

    Private Sub frm_Sample_References_Closed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        'Clear instance for Controls
        com_ReferencesUtlType = Nothing

    End Sub

#End Region

#Region " processing of ReadDeviceRandom Method "
    Private Sub btn_ReadDeviceRandom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadDeviceRandom.Click
        Dim iReturnCode As Integer              'return Code
        Dim szDeviceName As String = ""         'Data List of 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List Count of 'Device Name List'
        Dim iarrDeviceValue() As Integer        'Data for 'Device value'
        Dim szarrData() As String               'Data for 'Device value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameRandom.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeRandom, iNumberOfDeviceName) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Assign the array for 'DeviceValue'.
        ReDim iarrDeviceValue(iNumberOfDeviceName - 1)

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceRandom method
        '
        Try
            'System timers remain in High Resolution mode
            timeBeginPeriod(1)
            'Record the start time of Process
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'the ReadDeviceRandom method is executed.
                iReturnCode = com_ReferencesUtlType.ReadDeviceRandom(szDeviceName, _
                                                                     iNumberOfDeviceName, _
                                                                     iarrDeviceValue(0))
            Next
            'Record the end time of process.
            DateTimeEnd = Now
            'System timers remain in normal mode.
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception Processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(iNumberOfDeviceName - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To iNumberOfDeviceName - 1
                szarrData(iNumber) = iarrDeviceValue(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If
    End Sub
#End Region

#Region " Processing of WriteDeviceRandom button"

    Private Sub btn_WriteDeviceRandom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteDeviceRandom.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'Data List for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List count for 'Device Name List'
        Dim iarrDeviceValue() As Integer        'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'deviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameRandom.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeRandom, iNumberOfDeviceName) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'DeviceValue'.(If succeeded, the value is gotten.)
        ReDim iarrDeviceValue(iNumberOfDeviceName - 1)
        If GetIntArray(txt_DeviceDataRandom, iarrDeviceValue) = False Then
            'if Failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteDeviceRandom method
        '
        Try
            'System timers remain in High resolution Mode
            timeBeginPeriod(1)
            'record the start time of process
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry
                'The WriteDeviceRandom process is executed.
                iReturnCode = com_ReferencesUtlType.WriteDeviceRandom(szDeviceName, _
                                                                      iNumberOfDeviceName, _
                                                                      iarrDeviceValue(0))

            Next
            'record the end time of Process
            DateTimeEnd = Now
            'System timers remain in normal mode.
            timeEndPeriod(1)
            'Calclate the time span and dispkayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Excption processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)
    End Sub
#End Region

#Region " Processing of ReadDeviceBlock button "
    Private Sub btn_ReadDeviceBlock_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadDeviceBlock.Click
        Dim iReturnCode As Integer              'return Code
        Dim szDeviceName As String = ""         'Data List for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List count for 'Device Name List'
        Dim iharrDeviceValue() As Integer       'Data for 'Devce Value'
        Dim szarrData() As String               'Data for 'Devce Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameBlock.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeBlock, iNumberOfDeviceName) = False Then
            'If Failedm this process is end.
            Exit Sub
        End If

        'Allocate space for the device value
        ReDim iharrDeviceValue(iNumberOfDeviceName - 1)

        'Check the 'Retry Conut'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'if Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceBlock method
        '
        Try
            'System Timers remain in High Resolution Mode
            timeBeginPeriod(1)
            'record the start time of process
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The ReadDeviceBlock Method is executed.
                iReturnCode = com_ReferencesUtlType.ReadDeviceBlock(szDeviceName, _
                                                                    iNumberOfDeviceName, _
                                                                    iharrDeviceValue(0))

            Next
            'Record the end time of process
            DateTimeEnd = Now
            'System timers remain in Normal mode
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(iNumberOfDeviceName - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To iNumberOfDeviceName - 1
                szarrData(iNumber) = iharrDeviceValue(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If
    End Sub
#End Region

#Region " Processing of WriteDeviceBlock button "
    Private Sub btn_WriteDeviceBlock_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteDeviceBlock.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'List Data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 0  'List count for 'Device Name'
        Dim iarrDeviceValue() As Integer        'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameBlock.Lines)

        'Check the 'DeviceSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_DeviceSizeBlock, iNumberOfDeviceName) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        'Check the 'DeviceValue'.(If succeeded, the value is gotten.)
        ReDim iarrDeviceValue(iNumberOfDeviceName - 1)
        If GetIntArray(txt_DeviceDataBlock, iarrDeviceValue) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'RetryCount'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteDeviceBlock method
        '
        Try
            'System timers remain in High Resolution Mode
            timeBeginPeriod(1)
            'Record the start time of method.
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The WriteDeviceBlock Method is executed.
                iReturnCode = com_ReferencesUtlType.WriteDeviceBlock(szDeviceName, _
                                                                     iNumberOfDeviceName, _
                                                                     iarrDeviceValue(0))

            Next
            'record the end time of Method.
            DateTimeEnd = Now
            'System timers remain in Normal mode.
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception processing	
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing the GetDevice2 button."

    Private Sub btn_GetDevice2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_GetDevice2.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'Data List for 'Device Name'
        Dim shDeviceValue As Short              'Data for 'Device Value'
        Dim szarrData() As String               'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameSet.Lines)

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of GetDevice2 Method.
        '
        Try
            'System Timers remain in High resolution Mode.
            timeBeginPeriod(1)
            'Record the Start time of Method.
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The GetDevice2 method is executed.
                iReturnCode = com_ReferencesUtlType.GetDevice2(szDeviceName, _
                                                               shDeviceValue)

            Next
            'record the End time of Method.
            DateTimeEnd = Now
            'System timers remain in normal mode.
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(0)

            'Copy the read data to the 'arrData'.
            szarrData(0) = shDeviceValue.ToString()

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region

#Region " Processing of SetDevice2 button "
    Private Sub btn_SetDevice2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SetDevice2.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'Data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 1  'Data for 'Device Value'
        Dim sharrDeviceValue() As Short         'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameSet.Lines)

        'Check the 'DeviceData'.(If succeeded, the value is gotten.)
        ReDim sharrDeviceValue(iNumberOfDeviceName - 1)
        If GetShortArray(txt_DeviceDataSet, sharrDeviceValue) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadDeviceBlock2 method
        '
        Try
            'System timers remain in High resolution Mode
            timeBeginPeriod(1)
            'Record the start time of Method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'the SetDevice2 method is executed.
                iReturnCode = com_ReferencesUtlType.SetDevice2(szDeviceName, _
                                                               sharrDeviceValue(0))

            Next
            'record the end time of Method
            DateTimeEnd = Now
            'System timers remain in normal mode
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub
#End Region

#Region " Processing of GetDevice button "

    Private Sub btn_GetDevice_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_GetDevice.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'Data for 'Device Name List'
        Dim iDeviceValue As Integer             'Data for 'Device Value'
        Dim szarrData() As String               'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'Retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameSet.Lines)

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of GetDevice Method
        '
        Try
            'System timers remain in High resolution Mode
            timeBeginPeriod(1)
            'record the start time of method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'the GetDevice method is executed.
                iReturnCode = com_ReferencesUtlType.GetDevice(szDeviceName, _
                                                               iDeviceValue)

            Next
            'record the end time of method
            DateTimeEnd = Now
            'System timers remain in normal mode
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(0)

            'Copy the read data to the 'arrData'.
            szarrData(0) = iDeviceValue.ToString()

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region

#Region " Processing SetDevice Button Click "

    Private Sub btn_SetDevice_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SetDevice.Click

        Dim iReturnCode As Integer              'Return Code
        Dim szDeviceName As String = ""         'Data for 'Device Name'
        Dim iNumberOfDeviceName As Integer = 1  'Data Count for 'Device Name'
        Dim iarrDeviceValue() As Integer        'Data for 'Device Value'
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Get the list of 'DeviceName'.
        '  Join each line(StringType array) of 'DeviceName' by the separator '\n',
        '  and create a joined string data.
        szDeviceName = String.Join(vbLf, txt_DeviceNameSet.Lines)

        'Check the 'DeviceData'.(If succeeded, the value is gotten.)
        ReDim iarrDeviceValue(iNumberOfDeviceName - 1)
        If GetIntArray(txt_DeviceDataSet, iarrDeviceValue) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of SetDevice Method
        '
        Try
            'System Timer remain in High resolution mode
            timeBeginPeriod(1)
            'record the start time of Method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The SetDevice method is executed.
                iReturnCode = com_ReferencesUtlType.SetDevice2(szDeviceName, _
                                                               iarrDeviceValue(0))

            Next
            'record the end time of method
            DateTimeEnd = Now
            'System timer remain in Normal mode.
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)
    End Sub
#End Region

#Region " Processing GetCpuType Button Click"

    Private Sub btn_GetCpuType_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_GetCpuType.Click

        Dim iReturnCode As Integer              'Return Code
        Dim lCpuCode As Integer                 'Data for 'CPU Code'
        Dim szCpuName As String = ""            'Data for 'CPU Name'
        Dim szarrData() As String               'Data for cpu value
        Dim iNumber As Integer                  'Loop counter
        Dim iNumberOfRetry As Integer           'Retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of GetCpuType Method
        '
        Try
            'System timer remains in High Resolution Mode
            timeBeginPeriod(1)
            'record the start time of Method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'the GetCpuType method is executed.
                iReturnCode = com_ReferencesUtlType.GetCpuType(szCpuName, lCpuCode)
            Next
            'record the end time og method.
            DateTimeEnd = Now
            'System timer remain in normal mode
            timeEndPeriod(1)
            'Calclate the time span and display it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(1)

            'Copy the read data to the 'arrData'.
            szarrData(0) = szCpuName
            szarrData(1) = "0x" & lCpuCode.ToString("X8")

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region

#Region " Processing SetCpuType Button Click "

    Private Sub btn_SetCpuStatus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SetCpuStatus.Click

        Dim iReturnCode As Integer              'Return Code
        Dim iOperation As Integer               'Operation
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()


        'Check the 'Status'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_Status, iOperation) = False Then
            'if Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of SetCpuStatus method
        '
        Try
            'System timers remain in High resolution mode
            timeBeginPeriod(1)
            'Record the start time of method
            DateTimeStart = Now

            'The SetCpuStatus Method is executed
            iReturnCode = com_ReferencesUtlType.SetCpuStatus(iOperation)

            'Record the end time of method
            DateTimeEnd = Now
            'System timers remain in normal mode
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing of GetClockData Button Click "

    Private Sub btn_GetClockData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_GetClockData.Click

        Dim iReturnCode As Integer              'Return Code
        Dim iYear As Integer, iMonth As Integer, iDay As Integer, iWeek As Integer, iHour As Integer, iMin As Integer, iSec As Integer
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime
        Dim szarrData() As String               'Data for 'ClockData'

        'Displayed output data is cleared.
        ClearDisplay()

        '
        'Processing of GetClockData method
        '
        Try
            'System Timers remain in High Resolution Mode
            timeBeginPeriod(1)
            'Record the start time of Method
            DateTimeStart = Now

            'the GetClockData method is executed.
            iReturnCode = com_ReferencesUtlType.GetClockData(iYear, iMonth, iDay, iWeek, iHour, iMin, iSec)

            'Record the end time of method
            DateTimeEnd = Now
            'System timers remain in normal mode.
            timeEndPeriod(1)
            'Calclate time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(7)

            'Copy the read data to the 'arrData'.
            szarrData(0) = "Year:" & iYear.ToString()
            szarrData(1) = "Mon:" & iMonth.ToString()
            szarrData(2) = "Day:" & iDay.ToString()
            szarrData(3) = "Week:" & iWeek.ToString()
            szarrData(4) = "Hour:" & iHour.ToString()
            szarrData(5) = "Min:" & iMin.ToString()
            szarrData(6) = "Sec:" & iSec.ToString()

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If

    End Sub

#End Region

#Region " Processing of SetClockData Button Click "

    Private Sub btn_SetClockData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SetClockData.Click

        Dim iReturnCode As Integer              'Return Code
        Dim iYear As Integer, iMonth As Integer, iDay As Integer, iWeek As Integer, iHour As Integer, iMin As Integer, iSec As Integer
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Check the 'ClockData'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_Year, iYear) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If
        If GetIntValue(txt_Month, iMonth) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If
        If GetIntValue(txt_Day, iDay) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If
        If GetIntValue(txt_Week, iWeek) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If
        If GetIntValue(txt_Hour, iHour) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If
        If GetIntValue(txt_min, iMin) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If
        If GetIntValue(txt_sec, iSec) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of SetClockData method
        '
        Try
            'System timers remain in High Resolution Mode
            timeBeginPeriod(1)
            'record the start time of Method
            DateTimeStart = Now

            'The SetClockData Method is Executed
            iReturnCode = com_ReferencesUtlType.SetClockData(iYear, iMonth, iDay, iWeek, iHour, iMin, iSec)

            'record the end time of Method
            DateTimeEnd = Now
            'System timers remain in normal mode
            timeEndPeriod(1)
            'Calclate time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)


    End Sub

#End Region

#Region " Processing ReadBuffer Button Click "

    Private Sub btn_ReadBuffer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadBuffer.Click

        Dim iReturnCode As Integer              'Return Staus
        Dim sharrBuf() As Short                 'Data for 'ReadData'
        Dim lIOAddress As Integer               'Data for 'IOAddress'
        Dim lBufferAddress As Integer           'Data for 'BufferAddress'
        Dim lBufferSize As Integer              'Data for 'BufferSize'

        Dim szarrData() As String               'data Array for read data
        'Dim iCountarrData As Integer            'data count for read data
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'retry counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Check the 'IOAddress'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_IOAddress, lIOAddress) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'BufferAddress'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_BufferAddress, lBufferAddress) = False Then
            'if Failed, this process is end.
            Exit Sub
        End If

        'Check the 'BufferSize'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_BufferSize, lBufferSize) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Allocate the array for 'DeviceValue'.
        ReDim sharrBuf(lBufferSize - 1)

        'Check the 'RetryCount'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'if Failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of ReadBuffer method
        '
        Try
            'System Timers remain in High resolution mode
            timeBeginPeriod(1)
            'record the start time of method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'the ReadBuffer method is executed
                iReturnCode = com_ReferencesUtlType.ReadBuffer(lIOAddress, _
                                                                    lBufferAddress, _
                                                                    lBufferSize, _
                                                                    sharrBuf(0))

            Next
            'Record the end time of method
            DateTimeEnd = Now
            'System timers remain in normal mode
            timeEndPeriod(1)
            'Calclate time span and displayed it
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        '
        'Display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(lBufferSize - 1)

            'Copy the read data to the 'arrData'.
            For iNumber = 0 To lBufferSize - 1
                szarrData(iNumber) = sharrBuf(iNumber).ToString()
            Next iNumber

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData

        End If


    End Sub

#End Region

#Region " Processing of WriteBuffer button click "

    Private Sub btn_WriteBuffer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteBuffer.Click

        Dim iReturnCode As Integer              'Return Code
        Dim sharrBuf() As Short                 'Data for 'Write Data'
        Dim lIOAddress As Integer               'Data for 'IO Address'
        Dim lBufferAddress As Integer           'Data for 'Buffer Address'
        Dim lBufferSize As Integer              'Data for ]Buffer size'

        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'retry Counter
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime

        'Displayed output data is cleared.
        ClearDisplay()

        'Check the 'IO Address'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_IOAddress, lIOAddress) = False Then
            'If Failed, this method is end.
            Exit Sub
        End If

        'Check the 'Buffer Address'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_BufferAddress, lBufferAddress) = False Then
            'If Failed,this process is end.
            Exit Sub
        End If

        'Check the 'Buffer Size'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_BufferSize, lBufferSize) = False Then
            'if falied, this process is end.
            Exit Sub
        End If

        'Assign the array for 'write Data'.
        ReDim sharrBuf(lBufferSize - 1)
        'Check the 'Write Data'.(If succeeded, the value is gotten.)
        ReDim sharrBuf(lBufferSize - 1)
        If GetShortArray(txt_BufferData, sharrBuf) = False Then
            'if failed, this process is end.
            Exit Sub
        End If

        'Check the 'Retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'if failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of WriteBuffer method
        '
        Try
            'System timers remain in High Resolution Mode
            timeBeginPeriod(1)
            'record the start time of method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry

                'The WriteBuffer method is executed
                iReturnCode = com_ReferencesUtlType.WriteBuffer(lIOAddress, _
                                                                    lBufferAddress, _
                                                                    lBufferSize, _
                                                                    sharrBuf(0))

            Next
            'record the end time
            DateTimeEnd = Now
            'System timers remain in normal mode
            timeEndPeriod(1)
            'Calclate the time span and displayed it
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exException As Exception
            'Exception processing
            MessageBox.Show(exException.Message, Name, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

    End Sub

#End Region

#Region " Processing of GetErrorMessage Button Click "

    Private Sub btn_GetErrorMessage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_GetErrorMessage.Click

        Dim iReturnCode As Integer              'Return Code
        Dim iErrorCode As Integer               'Data for 'Error Code'
        Dim szErrorMessage As String = ""       'Data for 'Error Message'
        Dim szarrData() As String               'Data for 'Data Value'
        Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime
        Dim iNumber As Integer                  'Loop Counter
        Dim iNumberOfRetry As Integer           'retry Counter

        'Displayed output data is cleared.
        ClearDisplay()

        'Check the 'Error Message'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_GetErrorMessage, iErrorCode) = False Then
            'If Failed, this process is end.
            Exit Sub
        End If

        'Check the 'retry Count'.(If succeeded, the value is gotten.)
        If GetIntValue(txt_RetryCount, iNumberOfRetry) = False Then
            'if failed, this process is end.
            Exit Sub
        End If

        '
        'Processing of GetErrorMessage method
        '
        Try
            'System timers remain in High resolution mode
            timeBeginPeriod(1)
            'Record the start time of Method
            DateTimeStart = Now
            For iNumber = 1 To iNumberOfRetry


                'The GetErrorMessage is executed
                iReturnCode = com_ReferencesMsg.GetErrorMessage(iErrorCode, szErrorMessage)

            Next
            'record the end time of method
            DateTimeEnd = Now
            'system timers remain in normal mode
            timeEndPeriod(1)
            'Calclate the time span and displayed it.
            Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
            txt_AverageTime.Text = (TimeSpanRead.TotalMilliseconds / iNumberOfRetry).ToString("#0ms")
        Catch exception As Exception
            'Exception processing
            MessageBox.Show(exception.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End Try

        'The return code of the method is displayed by the hexadecimal.
        txt_ReturnCode.Text = String.Format("0x{0:x8} [HEX]", iReturnCode)

        'display the read data
        '
        'When method is successful. Display the read data
        If iReturnCode = 0 Then

            'Assign array for the read data.
            ReDim szarrData(0)

            'Copy the read data to the 'arrData'.
            szarrData(0) = szErrorMessage

            'Set the read data to the 'Data', and display it.
            txt_Data.Lines = szarrData
        End If


    End Sub

#End Region

End Class
