Public Class Form1
    Private communicationObject1 As communicationMX = Nothing    'Communication Class 1
    Private communicationObject2 As communicationMX = Nothing    'Communication class 2
    'Comm1 Open
    Private Sub btn_Open1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Open1.Click
        'create Communication object
        communicationObject1 = New communicationMX
        communicationObject1.pOrderOfThreadMX = 1
        'Check The 'LogicalStationNumber' (If failed, this process is end.)
        Dim LogicalStationNumber As Integer = 0
        If getLogicalStationNumber(txt_LogicalStationNumber1, LogicalStationNumber) = False Then
            communicationObject1 = Nothing
            Exit Sub
        End If
        communicationObject1.pLogicalStationNumber = LogicalStationNumber
        'Check The 'DeviceName' (If failed, this process is end.)
        Dim DeviceName As String = ""
        Dim DeviceCount As Integer = 0
        If getDeviceName(txt_DeviceName1, DeviceName, DeviceCount) = False Then
            communicationObject1 = Nothing
            Exit Sub
        End If
        communicationObject1.pDeviceName = DeviceName
        communicationObject1.pDeviceCount = DeviceCount
        'Check the 'Thread Execution intaval'(If failed, this process is end.)
        Dim SleepTime As Integer = 0
        If getSleepTime(txt_sleepTime1, SleepTime) = False Then
            communicationObject1 = Nothing
            Exit Sub
        End If
        communicationObject1.pSleepTime = SleepTime
        'Thread Start
        communicationObject1.Runthread()
        'Logging
        DisplayMessage(lst_ResultDisplay, "Thread1 Start.")
    End Sub
    'Comm1 Stop
    Private Sub btn_Stop1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Stop1.Click
        If communicationObject1 Is Nothing Then Exit Sub
        'Stop the Thread1
        communicationObject1.Stopthread()
        'delete the Communibation Object
        communicationObject1 = Nothing
        'Logging
        DisplayMessage(lst_ResultDisplay, "Thread1 Stopped.")
    End Sub
    'Thread2 start
    Private Sub btn_Open2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Open2.Click
        'create Communication object
        communicationObject2 = New communicationMX
        communicationObject2.pOrderOfThreadMX = 2
        'Check The 'LogicalStationNumber' (If failed, this process is end.)
        Dim LogicalStationNumber As Integer = 0
        If getLogicalStationNumber(txt_LogicalStationNumber2, LogicalStationNumber) = False Then
            communicationObject2 = Nothing
            Exit Sub
        End If
        communicationObject2.pLogicalStationNumber = LogicalStationNumber
        'Check The 'DeviceName' (If failed, this process is end.)
        Dim DeviceName As String = ""
        Dim DeviceCount As Integer = 0
        If getDeviceName(txt_DeviceName2, DeviceName, DeviceCount) = False Then
            communicationObject2 = Nothing
            Exit Sub
        End If
        communicationObject2.pDeviceName = DeviceName
        communicationObject2.pDeviceCount = DeviceCount
        'Check the 'Thread Execution intaval'(If failed, this process is end.)
        Dim SleepTime As Integer = 0
        If getSleepTime(txt_sleepTime2, SleepTime) = False Then
            communicationObject2 = Nothing
            Exit Sub
        End If
        communicationObject2.pSleepTime = SleepTime
        'Thread2 Start
        communicationObject2.Runthread()
        'Logging
        DisplayMessage(lst_ResultDisplay, "Thread2 start.")
    End Sub
    'Thread2 stop
    Private Sub btn_Stop2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Stop2.Click
        If communicationObject2 Is Nothing Then Exit Sub
        'Stop the Thread2
        communicationObject2.Stopthread()
        'delete the communication object
        communicationObject2 = Nothing
        'Logging
        DisplayMessage(lst_ResultDisplay, "Thread2 Stopped.")
    End Sub
    'Get 'LogicalStationNunber'
    Private Function getLogicalStationNumber(ByVal txtLogicalStationNumber As TextBox, ByRef LogicalStationNumber As Integer) As Integer
        'Initialize
        LogicalStationNumber = 0
        'Check the LogicalStationNumber
        If txtLogicalStationNumber.Text = "" Then
            MessageBox.Show("LogicaloStationNumber is not correct.", _
                        Application.LocalUserAppDataPath.ToString, _
                        MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End If
        'String to Integer
        Try
            LogicalStationNumber = Convert.ToInt32(txtLogicalStationNumber.Text)
        Catch eFormat As FormatException
            MessageBox.Show("Please Input Only Numeric character to LogicalStationNumber." _
                            & eFormat.ToString(), _
                            Application.LocalUserAppDataPath.ToString, _
                            MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        Catch eOverflow As OverflowException
            MessageBox.Show("LogicalStationNumber is out of range." _
                        & eOverflow.ToString(), _
                        Application.LocalUserAppDataPath.ToString, _
                        MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End Try
        Return True
    End Function
    'Get 'DeviceName'
    Private Function getDeviceName(ByVal txtDeviceName As TextBox, ByRef DeviceName As String, ByRef DeviceCount As Integer)
        'Check Input
        If txtDeviceName.Text.Equals("") = True Then
            MessageBox.Show("DeviceName is not correct.", _
                            Application.LocalUserAppDataPath.ToString, _
                            MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End If
        'DevicePoints Number Check
        DeviceCount = txtDeviceName.Lines.Length
        If DeviceCount > 20 Then
            MessageBox.Show("The total number of Device points exceeds the maximun number." _
                            & vbLf _
                            & "Please input within 20 points.", _
                            Application.LocalUserAppDataPath.ToString, _
                            MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End If
        'Set DeviceName and points
        DeviceName = ""
        For inNumber As Integer = 0 To DeviceCount - 1
            If inNumber <> 0 Then
                DeviceName = String.Concat(DeviceName, vbLf)
            End If
            DeviceName = String.Concat(DeviceName, txtDeviceName.Lines(inNumber))
        Next inNumber
        Return True
    End Function
    'get 'Thread execution interval'
    Private Function getSleepTime(ByVal txtLogicalStationNumber As TextBox, ByRef SleepTime As Integer) As Integer
        'Initialize
        SleepTime = 0
        'Input check
        If txtLogicalStationNumber.Text = "" Then
            MessageBox.Show("Thread execution interval is not correct.", _
                    Application.LocalUserAppDataPath.ToString, _
                    MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End If
        'Input value Check
        Try
            SleepTime = Convert.ToInt32(txtLogicalStationNumber.Text)
        Catch eFormat As FormatException
            MessageBox.Show("Please Input Only Numeric character to Thread execution interval." & _
                                eFormat.ToString(), _
                                Application.LocalUserAppDataPath.ToString, _
                                MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        Catch eOverflow As OverflowException
            MessageBox.Show("Thread Execution interval is out of range." & _
                                eOverflow.ToString(), _
                                Application.LocalUserAppDataPath.ToString, _
                                MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End Try
        Return True
    End Function
    'Set LoggiingMessage and displayed it
    Private Sub DisplayMessage(ByVal lst_ResultDisplay As ListBox, ByVal ErrorMessage As String)
        'set Current Date and time
        Dim dtNow As System.DateTime = Now
        Dim strNow As String = dtNow.ToString
        'logging
        lst_ResultDisplay.Items.Add(strNow & " " & ErrorMessage)
    End Sub
    'processing of Form Close button click
    Private Sub Form1_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        If Not (communicationObject1 Is Nothing) Then
            'Communication1 Stop
            communicationObject1.Stopthread()
            'Delete the object of Communication1
            communicationObject1 = Nothing
            'logging
            DisplayMessage(lst_ResultDisplay, "Thread1 stopped.")
        End If
        If Not (communicationObject2 Is Nothing) Then
            'Communication2 Stop
            communicationObject2.Stopthread()
            'Delete the object of Communication2
            communicationObject2 = Nothing
            'logging
            DisplayMessage(lst_ResultDisplay, "Thread2 Stopped.")
        End If
    End Sub
End Class

Public Class communicationMX

    Public Declare Function timeBeginPeriod Lib "winmm.dll" (ByVal uPeriod As Integer) As Integer
    Public Declare Function timeEndPeriod Lib "winmm.dll" (ByVal uPeriod As Integer) As Integer

    Private OrderOfThread As Integer = 0      'Thread ID
    Private LogicalStationNumber As Integer = 0 'Data for 'LogicalStationNumber'
    Private DeviceName As String = ""           'Data for 'DeviceName'
    Private DeviceCount As Integer = 0          'Data for 'Device Points Count'
    Private threadStatus As Integer = 0         'Data for 'Thread Status'
    Private Enum STATUS_THREAD As Integer       'Thread Status List
        STATUS_STOP = 0
        STATUS_RUN = 1
    End Enum
    Private thread As System.Threading.Thread   'Thread valiable
    Private SleepTime As Integer = 1000         'Thread execution interval
    'Property for Thread ID
    Public Property pOrderOfThreadMX() As Integer
        Get
            pOrderOfThreadMX = OrderOfThread
        End Get
        Set(ByVal value As Integer)
            OrderOfThread = value
        End Set
    End Property
    'property for LogicalStationNumber
    Public Property pLogicalStationNumber() As Integer
        Get
            pLogicalStationNumber = LogicalStationNumber
        End Get
        Set(ByVal value As Integer)
            LogicalStationNumber = value
        End Set
    End Property
    'property for DeviceName
    Public Property pDeviceName() As String
        Get
            pDeviceName = DeviceName
        End Get
        Set(ByVal value As String)
            DeviceName = value
        End Set
    End Property
    'Property for Device points Count
    Public Property pDeviceCount() As Integer
        Get
            pDeviceCount = DeviceCount
        End Get
        Set(ByVal value As Integer)
            DeviceCount = value
        End Set
    End Property
    'Property for Thread Status
    Private Property pthreadStatus() As Integer
        Get
            pthreadStatus = threadStatus
        End Get
        Set(ByVal value As Integer)
            threadStatus = value
        End Set
    End Property
    'Property for Thread execution interval
    Public Property pSleepTime() As Integer
        Get
            pSleepTime = SleepTime
        End Get
        Set(ByVal value As Integer)
            SleepTime = value
        End Set
    End Property
    'Create the thread
    Public Sub Runthread()
        thread = New System.Threading.Thread(New System.Threading.ThreadStart(AddressOf ThreadMethod))
        thread.TrySetApartmentState(Threading.ApartmentState.STA)
        thread.Start()
    End Sub
    'Main Method of Thread
    Private Sub ThreadMethod()
        'set thread status to property
        pthreadStatus = STATUS_THREAD.STATUS_RUN
        'create object
        Dim objCustomMultiObject As ActUtlTypeLib.ActUtlTypeClass = New ActUtlTypeLib.ActUtlTypeClass
        'declare valiable and initilaize
        Dim runOrderOfThread As Integer = pOrderOfThreadMX
        Dim runLogicalStationNumber As Integer = pLogicalStationNumber
        Dim runDeviceName As String = pDeviceName
        Dim runDeviceCount As Integer = pDeviceCount

        'declare Data Array for DeviceValue
        Dim DeviceValueArray() As Short
        DeviceValueArray = New Short(Me.pDeviceCount - 1) {}

        'main process of thread
        Dim runNumberOfTimes As Integer
        While pthreadStatus = STATUS_THREAD.STATUS_RUN
            runNumberOfTimes = runNumberOfTimes + 1
            If pthreadStatus = STATUS_THREAD.STATUS_STOP Then
                Exit While
            End If
            Dim ReturnCode As Integer
            Try
                objCustomMultiObject.ActLogicalStationNumber = LogicalStationNumber
                ReturnCode = objCustomMultiObject.Open()
                'If failed, logging the ErrorMessage
                If ReturnCode <> 0 Then
                    DisplayMessage(OrderOfThread, runNumberOfTimes, GetErrorMessage(ReturnCode))
                    Exit While
                Else
                    'DisplayMessage(OrderOfThread, NumberOfTimes, "Open")
                End If
            Catch exception As Exception
                DisplayMessage(OrderOfThread, runNumberOfTimes, _
                            "Communication Open error." & exception.ToString)
                Exit While
            End Try

            Dim DateTimeStart As System.DateTime, DateTimeEnd As System.DateTime
            'the ReadDeviceRandom2 method is executed.
            Try
                DisplayMessage(OrderOfThread, runNumberOfTimes, "ReadDeviceRandom2 start")
                DateTimeStart = Now
                ReturnCode = objCustomMultiObject.ReadDeviceRandom2(DeviceName, DeviceCount, DeviceValueArray(0))
                DateTimeEnd = Now
                'if failed, logging the Error message
                If ReturnCode <> 0 Then
                    DisplayMessage(OrderOfThread, runNumberOfTimes, GetErrorMessage(ReturnCode))
                Else
                    Dim DeviceValue As String = ""
                    For Number As Integer = 0 To DeviceCount - 1
                        DeviceValue = DeviceValue & Number.ToString("arr(#0)") & "=" & DeviceValueArray(Number).ToString("#,0") & ","
                    Next Number
                    Dim TimeSpanRead As System.TimeSpan = DateTimeEnd - DateTimeStart
                    DisplayMessage(OrderOfThread, runNumberOfTimes, "ReadDeviceRandom2 end " & TimeSpanRead.TotalMilliseconds.ToString("#0ms") & " " & DeviceValue)
                End If
            Catch exception As Exception
                DisplayMessage(OrderOfThread, runNumberOfTimes, _
                            "ReadDeviceRandom2 Error." & exception.ToString)
            End Try

            'Communication Close
            Try
                ReturnCode = objCustomMultiObject.Close()
                'if Failed, logging the Errormessage
                If ReturnCode <> 0 Then
                    DisplayMessage(OrderOfThread, runNumberOfTimes, GetErrorMessage(ReturnCode))
                Else
                    'DisplayMessage(OrderOfThread, NumberOfTimes, "Close")
                End If
            Catch exception As Exception
                DisplayMessage(OrderOfThread, runNumberOfTimes, "Communication Close error." _
                                            & exception.ToString)
            End Try
            'System timers remain in high resolution mode
            timeBeginPeriod(1)
            'wait for next execution interval
            Threading.Thread.Sleep(SleepTime)
            'System timers remain in normal mode
            timeEndPeriod(1)
        End While
        'Delete the control object
        objCustomMultiObject = Nothing
        'delete array
        DeviceValueArray = Nothing
        'set thread status to property
        Me.pthreadStatus = STATUS_THREAD.STATUS_STOP
    End Sub
    'Thread stopping
    Public Sub Stopthread()
        'set thread status to property
        pthreadStatus = STATUS_THREAD.STATUS_STOP
        'Wait for Thread Stopped
        thread.Join()
        'delete thread
        thread = Nothing
    End Sub
    'Get ErrorMessage from ActSupportMsgType Control
    Private Function GetErrorMessage(ByVal MessageCode As Integer) As String
        GetErrorMessage = ""
        'The GetErrorMessage method is executed.
        Dim ErrorMessage As String = ""
        Dim ReturnCode As Integer = 0
        Dim objCustomSupportObject = New ActSupportMsgLib.ActSupportMsgClass
        ReturnCode = objCustomSupportObject.GetErrorMessage(MessageCode, ErrorMessage)
        If ReturnCode <> 0 Then
            GetErrorMessage = "GetErrorMessage method is failed." & vbLf & String.Format("  Error Code = <{0}>", MessageCode)
        Else
            ErrorMessage = ErrorMessage.Replace(Environment.NewLine, " ")
            GetErrorMessage = "" & ErrorMessage
        End If
        objCustomSupportObject = Nothing
    End Function
    'set errorMessage to Display
    Private Function DisplayMessage(ByVal OrderOfThread As Integer, ByVal NumberOfTimes As Integer, ByVal Message As String)
        'Create message text
        Dim dtNow As System.DateTime = Now
        Dim strNow As String = dtNow.ToString("yyyy/MM/dd HH:mm:ss.fff")
        'Display on console
        Console.Write(strNow & " <Thread" & OrderOfThread & ":" & NumberOfTimes & ">" & Message & vbCrLf)
        Return True
    End Function
End Class
